% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{zwl_test}
\alias{zwl_test}
\title{High-dimensional two-sample test proposed by Zhang and Wang (2020)}
\usage{
zwl_test(X, Y, order = 0)
}
\arguments{
\item{X}{The data matrix (n by p) from the first population.}

\item{Y}{The data matrix (m by p) from the second population.}

\item{order}{The order of center correction. Possible choices are 0,  2.
To use the ZWLm test, set \code{order = 0}; to use the ZWL test, set \code{order = 2}. For moderate sample sizes, ZWLm is recommended.}
}
\value{
\describe{
\item{statistic}{The value of the test statistic.}
\item{pvalue}{The p-value of the test statistic based on the asymptotic normality established by Zhang and Wang (2020)}
\item{Tn}{The average of the squared univariate t-statistics.}
\item{var}{The estimated variance of Tn}
}
}
\description{
This function implements the test of equal mean for two-sample high-dimension data using the ZWL and ZWLm tests proposed by Zhang and Wang (2020).
}
\examples{
# Generate a simulated two-sample dataset and apply the ZWL test
data <- buildData(n = 45, m =60, p = 300,
          muX = rep(0,300), muY = rep(0,300),
          dep = 'IND', S = 1, innov = rnorm)
zwl_test(data[[1]]$X, data[[1]]$Y, order = 2)

# Apply the ZWLm test to a GO term to see if the two groups are differentiately expressed.
# The data for the GO term were stored in GO_example.
zwl_test(GO_example$X, GO_example$Y, order = 0)
# Apply the ZWL test to the GO term
zwl_test(GO_example$X, GO_example$Y, order = 2)


}
\references{
Zhang, H. and Wang, H. (2020). Result consistency of high dimensional
two-sample tests applied to gene ontology terms with gene sets. Manuscript in review.
}
