% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/higrad.R
\name{predict.higrad}
\alias{predict.higrad}
\title{Obtain Prediction and Confidence Intervals From a HiGrad Fit}
\usage{
\method{predict}{higrad}(object, newx, alpha = 0.05, type = "link",
  prediction.interval = FALSE, ...)
}
\arguments{
\item{object}{a fitted object of class \code{higrad}.}

\item{newx}{matrix of new values for \code{x} at which predictions are to be made.}

\item{alpha}{significance level. The confidence level of the interval is thus 1 - \code{alpha}.}

\item{type}{type of prediction required. Type \code{"link"} gives the linear predictors for \code{"logistic"}; for \code{"lm"} models it gives the fitted values. Type \code{"response"} gives the fitted probabilities for \code{"logistic"}; for \code{"lm"} type \code{"response"} is equivalent to type \code{"link"}.}

\item{prediction.interval}{logical; indicator of whether prediction intervals should be returned instead of confidence intervals.}

\item{...}{other prediction options.}
}
\value{
A list with components
\item{pred}{predicted values.}
\item{upper}{upper limit of the confidence/prediction intervals.}
\item{lower}{lower limit of the confidence/prediction intervals.}
}
\description{
\code{predict} can be applied with a \code{higrad} object to obtain predictions and confidence intervals.
}
