#' Count of Fresh Gopher Tortoise Shells
#'
#' A dataset containing the count of fresh gopher shells by area.
#'
#' @format A data frame with 30 rows and 7 variables:
#' \describe{
#'   \item{Site}{name of site}
#'   \item{year}{years 2004, 2005, 2006}
#'   \item{shells}{count of shells}
#'   \item{type}{fresh water}
#'   \item{Area}{area of the site}
#'   \item{density}{estimated tortoise density}
#'   \item{prev}{Seroprevalence to Mycoplasma agassizii}
#' }
#' @references Fox, G. A., Negrete-Yankelevich, S., & Sosa, V. J. (Eds.). (2015). \emph{Ecological statistics: contemporary theory and application}. Oxford University Press, USA.
#' @source Ozgul, A., Oli, M. K., Bolker, B. M., & Perez-Heydrich, C. (2009). \emph{Upper respiratory tract disease, force of infection, and effects on survival of gopher tortoises}. Ecological Applications, 19(3), 786–798
#' @references Bolker, Ben (2018) GLMM Worked Examples  \url{https://bbolker.github.io/mixedmodels-misc/ecostats_chap.html}
"Gdat"

#' Endometrial Cancer Dataset
#'
#' Data from a study about Endometrial Cancer
#'
#' @format A data frame with 79 rows and 4 variables:
#' \describe{
#'   \item{NV}{Neovasculation risk factor indicator (0=Absent, 1=Present)}
#'   \item{PI}{Pulsatility index of arteria uterina}
#'   \item{EH}{Endometrium height}
#'   \item{HG}{histology of patient (0=Low, 1=High)}
#' }
#' @references Agresti, A. (2015). \emph{Foundations of linear and generalized linear models}. John Wiley & Sons.  \url{http://users.stat.ufl.edu/~aa/glm/data/Endometrial.dat}
#' @source Heinze, G., & Schemper, M. (2002). \emph{A solution to the problem of separation in logistic regression}. Statistics in medicine, 21(16), 2409-2419.
"Endometrial"

#' Student Drug Usage Dataset
#'
#' Data from a survey of 2276 high school students about drug usage
#'
#' @format A data frame with 8 rows and 4 variables:
#' \describe{
#'   \item{A}{Alcohol usage (Yes/No)}
#'   \item{C}{Cigarette usage (Yes/No)}
#'   \item{M}{Marijuana usage (Yes/No)}
#'   \item{count}{number of responses}
#' }
#' @references Agresti, A. (2015). \emph{Foundations of linear and generalized linear models}. John Wiley & Sons.  \url{http://users.stat.ufl.edu/~aa/glm/data/Drugs.dat}
#' @source Data originally provided by Harry Khamis, Wright State University
"Drugs"



