% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/con_twoletter_holland.R
\name{con_twoletter_holland}
\alias{con_twoletter_holland}
\title{Congruence Index according to Healy & Mourton (1983)}
\usage{
con_twoletter_holland(a, b)
}
\arguments{
\item{a}{a character vector with person Holland codes.}

\item{b}{a character vector with environment Holland codes.}
}
\value{
a numeric with value for congruence.
}
\description{
The function computes the two-letter congruence index according to Healy & Mourton (1983).
}
\details{
The function finds the congruence according to Healy & Mourton (1983) between the two-letter Holland codes given in argument a, which is the person code, and argument b, which is the environment code. The Index as defined by Healy & Mourton (1983) targets (only) two letters from the Holland code. The degree of congruence is output, according to its definition by Healy & Mourton (1983), as a reciprocal value of a distance. This means, for example, that a value of '3' is the result for a perfect fit of two two-letter codes !
}
\examples{
con_twoletter_holland(a="RI",b="SE") # max. difference 
con_twoletter_holland(a="RI",b="RI") # max. similarity
}
\references{
Holland, J.L. 1963. A theory of vocational choice. I. Vocational images and choice. \emph{Vocational Guidance Quarterly, 11}(4), 232–239.

Healy, C. C. & Mourton, D. L. (1983). Derivatives of the Self-Directed Search: Potential clinical and evaluative uses. \emph{Journal of Vocational Behavior, 23}(3), 318–328. https://doi.org/10.1016/0001-8791(83)90045-3
}
\keyword{congruence}
