% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datagen.R
\name{datagen}
\alias{datagen}
\title{Multiple Normal Distribution Data Generation}
\usage{
datagen(n, mu, sigma, tn = 1)
}
\arguments{
\item{n}{Sample sizes of each group. n=c(n1,n2,...nk); for example: n=c(3, 4, 5).}

\item{mu}{Mean  of each group.mu=c(mu1,mu2,...muk); for example: mu=c(3, 4, 5).}

\item{sigma}{Standard deviation of each group.sigma=c(sigma1,sigma2,...sigmak);
for example: sigma=c(1, 2, 3).}

\item{tn}{Trial number for all groups. Default of the parameter is 1.
This parameter for use more than 1, is especially useful for resampling
such as Monte Carlo, Parametric Bootstrap.}
}
\value{
a data matrix with size (n1,n2,...nk) with group number 1,2,...k at first row and random number with
mnean mu=(mu1,mu2,...muk) and standard deviation  sigma=(sigma1,sigma2,...sigmak)
}
\description{
This function generates data from multiple normal distribution.
}
\examples{

n=c(3, 4, 5)
mu=c(3, 4, 5)
sigma=c(3, 4, 5)
F=datagen(n,mu,sigma);muh=F[1];S2h=F[2];x=F[3]
muh
S2h
x

# Following example especially useful for simulation based tecnhiques
# such as Monte Carlo, Parametric Bootstrap and comparison studies
# by using simulation.

 Fm=datagen(c(3, 4, 5),c(3, 4, 5),c(3, 4, 5),10);muhm=Fm[1];S2hm=Fm[2];xm=Fm[3]
muhm
S2hm
xm
}
