% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kp_ratings_tables.R
\name{kp_pointdist}
\alias{kp_pointdist}
\title{\strong{Get Team Points Distribution}}
\usage{
kp_pointdist(min_year, max_year = most_recent_mbb_season())
}
\arguments{
\item{min_year}{First year of data to pull}

\item{max_year}{Last year of data to pull}
}
\value{
Returns a tibble of team points distributions\tabular{ll}{
   col_name \tab types \cr
   team \tab character \cr
   conf \tab character \cr
   off_ft_pct \tab numeric \cr
   off_ft_pct_rk \tab numeric \cr
   off_fg_2_pct \tab numeric \cr
   off_fg_2_pct_rk \tab numeric \cr
   off_fg_3_pct \tab numeric \cr
   off_fg_3_pct_rk \tab numeric \cr
   def_ft_pct \tab numeric \cr
   def_ft_pct_rk \tab numeric \cr
   def_fg_2_pct \tab numeric \cr
   def_fg_2_pct_rk \tab numeric \cr
   def_fg_3_pct \tab numeric \cr
   def_fg_3_pct_rk \tab numeric \cr
   ncaa_seed \tab numeric \cr
   year \tab numeric \cr
}
}
\description{
\strong{Get Team Points Distribution}
}
\examples{
\donttest{
   try(kp_pointdist(min_year = 2020, max_year = 2021))
}
}
\seealso{
Other KenPom Ratings Functions: 
\code{\link{kp_efficiency}()},
\code{\link{kp_foul_trouble}()},
\code{\link{kp_fourfactors}()},
\code{\link{kp_height}()},
\code{\link{kp_kpoy}()},
\code{\link{kp_playerstats}()},
\code{\link{kp_pomeroy_ratings}()},
\code{\link{kp_teamstats}()}
}
\concept{KenPom Ratings Functions}
\keyword{Points}
