% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_lineups.R
\name{nba_fantasywidget}
\alias{nba_fantasywidget}
\title{\strong{Get NBA Stats API Fantasy Widget}}
\usage{
nba_fantasywidget(
  active_players = "N",
  date_from = "",
  date_to = "",
  last_n_games = 0,
  league_id = "00",
  location = "",
  month = "",
  opponent_team_id = "",
  po_round = "",
  player_id = "",
  position = "",
  season = year_to_season(most_recent_nba_season() - 1),
  season_segment = "",
  season_type = "Regular Season",
  team_id = "",
  todays_opponent = 0,
  todays_players = "N",
  vs_conference = "",
  vs_division = "",
  ...
)
}
\arguments{
\item{active_players}{active_players}

\item{date_from}{date_from date_from}

\item{date_to}{date_to date_to}

\item{last_n_games}{last_n_games}

\item{league_id}{league_id}

\item{location}{location}

\item{month}{month}

\item{opponent_team_id}{opponent_team_id}

\item{po_round}{po_round}

\item{player_id}{player_id}

\item{position}{position}

\item{season}{season}

\item{season_segment}{season_segment}

\item{season_type}{season_type}

\item{team_id}{team_id}

\item{todays_opponent}{todays_opponent}

\item{todays_players}{todays_players}

\item{vs_conference}{vs_conference}

\item{vs_division}{vs_division}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Returns a named list of data frames: FantasyWidgetResult

\strong{FantasyWidgetResult}\tabular{ll}{
   col_name \tab types \cr
   PLAYER_ID \tab character \cr
   PLAYER_NAME \tab character \cr
   PLAYER_POSITION \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   GP \tab character \cr
   MIN \tab character \cr
   FAN_DUEL_PTS \tab character \cr
   NBA_FANTASY_PTS \tab character \cr
   PTS \tab character \cr
   REB \tab character \cr
   AST \tab character \cr
   BLK \tab character \cr
   STL \tab character \cr
   TOV \tab character \cr
   FG3M \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   FTA \tab character \cr
   FT_PCT \tab character \cr
}
}
\description{
\strong{Get NBA Stats API Fantasy Widget}

\strong{Get NBA Stats API Fantasy Widget}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_fantasywidget(league_id = '00', season = year_to_season(most_recent_nba_season() - 1))
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA Fantasy Functions: 
\code{\link{nba_infographicfanduelplayer}()},
\code{\link{nba_playerfantasyprofilebargraph}()},
\code{\link{nba_playerfantasyprofile}()}
}
\author{
Saiem Gilani
}
\concept{NBA Fantasy Functions}
