% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_player.R
\name{nba_playerestimatedmetrics}
\alias{nba_playerestimatedmetrics}
\title{\strong{Get NBA Stats API Player Estimated Metrics}}
\usage{
nba_playerestimatedmetrics(
  league_id = "00",
  season = year_to_season(most_recent_nba_season() - 1),
  season_type = "Regular Season",
  ...
)
}
\arguments{
\item{league_id}{League - default: '00'. Other options include '10': WNBA, '20': G-League}

\item{season}{Season - format 2020-21}

\item{season_type}{Season Type - Regular Season, Playoffs, All-Star}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a named list of data frames: PlayerEstimatedMetrics

\strong{PlayerEstimatedMetrics}\tabular{ll}{
   col_name \tab types \cr
   PLAYER_ID \tab character \cr
   PLAYER_NAME \tab character \cr
   GP \tab character \cr
   W \tab character \cr
   L \tab character \cr
   W_PCT \tab character \cr
   MIN \tab character \cr
   E_OFF_RATING \tab character \cr
   E_DEF_RATING \tab character \cr
   E_NET_RATING \tab character \cr
   E_AST_RATIO \tab character \cr
   E_OREB_PCT \tab character \cr
   E_DREB_PCT \tab character \cr
   E_REB_PCT \tab character \cr
   E_TOV_PCT \tab character \cr
   E_USG_PCT \tab character \cr
   E_PACE \tab character \cr
   GP_RANK \tab character \cr
   W_RANK \tab character \cr
   L_RANK \tab character \cr
   W_PCT_RANK \tab character \cr
   MIN_RANK \tab character \cr
   E_OFF_RATING_RANK \tab character \cr
   E_DEF_RATING_RANK \tab character \cr
   E_NET_RATING_RANK \tab character \cr
   E_AST_RATIO_RANK \tab character \cr
   E_OREB_PCT_RANK \tab character \cr
   E_DREB_PCT_RANK \tab character \cr
   E_REB_PCT_RANK \tab character \cr
   E_TOV_PCT_RANK \tab character \cr
   E_USG_PCT_RANK \tab character \cr
   E_PACE_RANK \tab character \cr
}
}
\description{
\strong{Get NBA Stats API Player Estimated Metrics}

\strong{Get NBA Stats API Player Estimated Metrics}
}
\details{
\href{https://www.nba.com/stats/players/estimated-advanced}{Player Estimated Metrics}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_playerestimatedmetrics()
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA Player Functions: 
\code{\link{nba_infographicfanduelplayer}()},
\code{\link{nba_leaguedashplayerbiostats}()},
\code{\link{nba_leaguedashplayerclutch}()},
\code{\link{nba_leaguedashplayershotlocations}()},
\code{\link{nba_leaguedashplayerstats}()},
\code{\link{nba_leagueplayerondetails}()},
\code{\link{nba_leagueseasonmatchups}()},
\code{\link{nba_matchupsrollup}()},
\code{\link{nba_playerawards}()},
\code{\link{nba_playercareerbycollegerollup}()},
\code{\link{nba_playercareerbycollege}()},
\code{\link{nba_playercareerstats}()},
\code{\link{nba_playercompare}()},
\code{\link{nba_playerdashboardbyclutch}()},
\code{\link{nba_playerdashboardbygamesplits}()},
\code{\link{nba_playerdashboardbygeneralsplits}()},
\code{\link{nba_playerdashboardbylastngames}()},
\code{\link{nba_playerdashboardbyopponent}()},
\code{\link{nba_playerdashboardbyshootingsplits}()},
\code{\link{nba_playerdashboardbyteamperformance}()},
\code{\link{nba_playerdashboardbyyearoveryear}()},
\code{\link{nba_playerdashptpass}()},
\code{\link{nba_playerdashptreb}()},
\code{\link{nba_playerdashptshotdefend}()},
\code{\link{nba_playerdashptshots}()},
\code{\link{nba_playerfantasyprofilebargraph}()},
\code{\link{nba_playerfantasyprofile}()},
\code{\link{nba_playergamelogs}()},
\code{\link{nba_playergamelog}()},
\code{\link{nba_playergamestreakfinder}()},
\code{\link{nba_playerheadshot}()},
\code{\link{nba_playerindex}()},
\code{\link{nba_playernextngames}()},
\code{\link{nba_playerprofilev2}()},
\code{\link{nba_playervsplayer}()}
}
\author{
Saiem Gilani
}
\concept{NBA Player Functions}
