% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_player.R
\name{nba_playerfantasyprofilebargraph}
\alias{nba_playerfantasyprofilebargraph}
\title{\strong{Get NBA Stats API Player Fantasy Profile Bar Graph}}
\usage{
nba_playerfantasyprofilebargraph(
  league_id = "00",
  player_id = "2544",
  season = year_to_season(most_recent_nba_season() - 1),
  season_type = "Regular Season",
  ...
)
}
\arguments{
\item{league_id}{League - default: '00'. Other options include '10': WNBA, '20': G-League}

\item{player_id}{Player ID}

\item{season}{Season - format 2020-21}

\item{season_type}{Season Type - Regular Season, Playoffs, All-Star}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a named list of data frames: LastFiveGamesAvg, SeasonAvg

\strong{SeasonAvg}\tabular{ll}{
   col_name \tab types \cr
   PLAYER_ID \tab character \cr
   PLAYER_NAME \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   FAN_DUEL_PTS \tab character \cr
   NBA_FANTASY_PTS \tab character \cr
   PTS \tab character \cr
   REB \tab character \cr
   AST \tab character \cr
   FG3M \tab character \cr
   FT_PCT \tab character \cr
   STL \tab character \cr
   BLK \tab character \cr
   TOV \tab character \cr
   FG_PCT \tab character \cr
}


\strong{LastFiveGamesAvg}\tabular{ll}{
   col_name \tab types \cr
   PLAYER_ID \tab character \cr
   PLAYER_NAME \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   FAN_DUEL_PTS \tab character \cr
   NBA_FANTASY_PTS \tab character \cr
   PTS \tab character \cr
   REB \tab character \cr
   AST \tab character \cr
   FG3M \tab character \cr
   FT_PCT \tab character \cr
   STL \tab character \cr
   BLK \tab character \cr
   TOV \tab character \cr
   FG_PCT \tab character \cr
}
}
\description{
\strong{Get NBA Stats API Player Fantasy Profile Bar Graph}

\strong{Get NBA Stats API Player Fantasy Profile Bar Graph}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_playerfantasyprofilebargraph(player_id = '2544')
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA Player Functions: 
\code{\link{nba_infographicfanduelplayer}()},
\code{\link{nba_leaguedashplayerbiostats}()},
\code{\link{nba_leaguedashplayerclutch}()},
\code{\link{nba_leaguedashplayershotlocations}()},
\code{\link{nba_leaguedashplayerstats}()},
\code{\link{nba_leagueplayerondetails}()},
\code{\link{nba_leagueseasonmatchups}()},
\code{\link{nba_matchupsrollup}()},
\code{\link{nba_playerawards}()},
\code{\link{nba_playercareerbycollegerollup}()},
\code{\link{nba_playercareerbycollege}()},
\code{\link{nba_playercareerstats}()},
\code{\link{nba_playercompare}()},
\code{\link{nba_playerdashboardbyclutch}()},
\code{\link{nba_playerdashboardbygamesplits}()},
\code{\link{nba_playerdashboardbygeneralsplits}()},
\code{\link{nba_playerdashboardbylastngames}()},
\code{\link{nba_playerdashboardbyopponent}()},
\code{\link{nba_playerdashboardbyshootingsplits}()},
\code{\link{nba_playerdashboardbyteamperformance}()},
\code{\link{nba_playerdashboardbyyearoveryear}()},
\code{\link{nba_playerdashptpass}()},
\code{\link{nba_playerdashptreb}()},
\code{\link{nba_playerdashptshotdefend}()},
\code{\link{nba_playerdashptshots}()},
\code{\link{nba_playerestimatedmetrics}()},
\code{\link{nba_playerfantasyprofile}()},
\code{\link{nba_playergamelogs}()},
\code{\link{nba_playergamelog}()},
\code{\link{nba_playergamestreakfinder}()},
\code{\link{nba_playerheadshot}()},
\code{\link{nba_playerindex}()},
\code{\link{nba_playernextngames}()},
\code{\link{nba_playerprofilev2}()},
\code{\link{nba_playervsplayer}()}

Other NBA Fantasy Functions: 
\code{\link{nba_fantasywidget}()},
\code{\link{nba_infographicfanduelplayer}()},
\code{\link{nba_playerfantasyprofile}()}
}
\author{
Saiem Gilani
}
\concept{NBA Fantasy Functions}
\concept{NBA Player Functions}
