test_that("hoopR Loader NBA Play-by-Play", {
  skip_on_cran()
  x <- load_nba_pbp(seasons = most_recent_nba_season())


  cols <- c(
    "game_play_number",
    "id",
    "sequence_number",
    "type_id",
    "type_text",
    "text",
    "away_score",
    "home_score",
    "period_number",
    "period_display_value",
    "clock_display_value",
    "scoring_play",
    "score_value",
    "team_id",
    "athlete_id_1",
    "athlete_id_2",
    "athlete_id_3",
    "wallclock",
    "shooting_play",
    "coordinate_x_raw",
    "coordinate_y_raw",
    "game_id",
    "season",
    "season_type",
    "home_team_id",
    "home_team_name",
    "home_team_mascot",
    "home_team_abbrev",
    "home_team_name_alt",
    "away_team_id",
    "away_team_name",
    "away_team_mascot",
    "away_team_abbrev",
    "away_team_name_alt",
    "game_spread",
    "home_favorite",
    "game_spread_available",
    "home_team_spread",
    "qtr",
    "time",
    "clock_minutes",
    "clock_seconds",
    "home_timeout_called",
    "away_timeout_called",
    "half",
    "game_half",
    "lead_qtr",
    "lead_half",
    "start_quarter_seconds_remaining",
    "start_half_seconds_remaining",
    "start_game_seconds_remaining",
    "end_quarter_seconds_remaining",
    "end_half_seconds_remaining",
    "end_game_seconds_remaining",
    "period",
    "lag_qtr",
    "lag_half",
    "coordinate_x",
    "coordinate_y",
    "game_date",
    "game_date_time",
    "type_abbreviation"
  )

  expect_equal(sort(colnames(x)), sort(cols))
  expect_s3_class(x, "data.frame")

})
