% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Stability.R
\name{ApproxC}
\alias{ApproxC}
\title{Approximate, dynamic iterative computation of the stability constant for a workload of a High Performance Cluster model}
\usage{
ApproxC(s, p, depth = 3)
}
\arguments{
\item{s}{number of servers in the model}

\item{p}{vector of class distribution}

\item{depth}{By default calculates up to groups of 3 tasks. When depth=s, calculates the exact value. However, depth=s might take a bit more time.}
}
\value{
The value of a constant C in the relation lambda/mu < C is returned
}
\description{
This function calculates the constant C that is used in the stability criterion
of a supercomputer model, which is basically the following: lambda/mu<C, where lambda
is the task arrivals rate, and mu is the service intensity. The constant depends only on
the number of servers in the model and the distribution of classes of customers,
where class is the number of servers required. This method of calculation allows 
to stop on some depth of dynamics, thus allowing to calculate an approximate value in
faster time. The constant is valid only for the model with simultaneous service.
}
\examples{
ApproxC(s=2,p=c(.5,.5), depth=3)
}
