% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h_rbind.R
\name{h_rbind}
\alias{h_rbind}
\title{Bind 2 time-series on consecutive periods}
\usage{
h_rbind(files, sensor = "NewS", gap = TRUE)
}
\arguments{
\item{files}{List of char, File names to process.}

\item{sensor}{New sensor name of the resulting hts file (default ="NewS")}

\item{gap}{Introduce or not a gap between both series (default = TRUE)}
}
\value{
hts file resulting of the operation; its names are composed as:
<sensor>_<station>.hts, with the prefix na, if a gap has been introduced.
}
\description{
The fonction binds the data of 2 hts time-series
for consecutive date/time records (precision of the second) of the same station.
}
\details{
In the list, the files must be ordered from the oldest to the newest.
If gap is TRUE, a gap is introduced between both series.
}
\examples{
\dontrun{

f <- h_bind(files = c("foo1.hts","foo2.hts"), sensor = "NewOne")
}

}
\author{
P. Chevallier - Mar-Nov 2020
}
