% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v3-schema-utils.R
\name{is_v3_hub}
\alias{is_v3_hub}
\title{Is hub configured using v3.0.0 schema?}
\usage{
is_v3_hub(hub_path, config = c("tasks", "admin"))
}
\arguments{
\item{hub_path}{Either a character string path to a local Modeling Hub directory
or an object of class \verb{<SubTreeFileSystem>} created using functions \code{\link[arrow:s3_bucket]{arrow::s3_bucket()}}
or \code{\link[arrow:gs_bucket]{arrow::gs_bucket()}} by providing a string S3 or GCS bucket name or path to a
Modeling Hub directory stored in the cloud.
For more details consult the
\href{https://arrow.apache.org/docs/r/articles/fs.html}{Using cloud storage (S3, GCS)}
in the \code{arrow} package.}

\item{config}{Name of config file to validate. One of \code{"tasks"} or \code{"admin"}.}
}
\value{
Logical, whether the hub is configured using v3.0.0 schema.
}
\description{
Is hub configured using v3.0.0 schema?
}
\examples{
is_v3_hub(hub_path = system.file("testhubs", "flusight", package = "hubUtils"))
}
