% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iwanthue.R
\name{iwanthue}
\alias{iwanthue}
\title{Generate a colour palette by k-means clustering of CIE Lab colour space.}
\usage{
iwanthue(
  n,
  hmin = 0,
  hmax = 360,
  cmin = 0,
  cmax = 180,
  lmin = 0,
  lmax = 100,
  plot = FALSE,
  random = FALSE
)
}
\arguments{
\item{n}{Numeric. The number of colours to generate.}

\item{hmin}{Numeric, in the range \verb{[0, 360]}. The lower limit of the hue
range to be clustered.}

\item{hmax}{Numeric, in the range \verb{[0, 360]}. The upper limit of the hue
range to be clustered.}

\item{cmin}{Numeric, in the range \verb{[0, 180]}. The lower limit of the chroma
range to be clustered.}

\item{cmax}{Numeric, in the range \verb{[0, 180]}. The upper limit of the chroma
range to be clustered.}

\item{lmin}{Numeric, in the range \verb{[0, 100]}. The lower limit of the
luminance range to be clustered.}

\item{lmax}{Numeric, in the range \verb{[0, 100]}. The upper limit of the
luminance range to be clustered.}

\item{plot}{Logical. Should the colour swatches be plotted (using
\code{\link[=swatch]{swatch()}})?}

\item{random}{Logical. If \code{TRUE}, clustering will be determined by the
existing RNG state. If \code{FALSE}, the seed will be set to \code{1} for clustering,
and on exit, the function will restore the pre-existing RNG state.}
}
\value{
A vector of \code{n} colours (as hexadecimal strings), representing
centers of clusters determined through k-means clustering of the CIE Lab
colour space delimited by \code{hmin}, \code{hmax}, \code{cmin}, \code{cmax}, \code{lmin} and
\code{lmax}.
}
\description{
Generate a palette of distinct colours through k-means clustering of CIE Lab
colour space.
}
\details{
Note that \code{iwanthue} currently doesn't support \code{hmin} greater than
\code{hmax} (which should be allowed, since hue is circular).
}
\examples{
iwanthue(5)
iwanthue(5, plot=TRUE)
iwanthue(5, 0, 240, 0, 24, 0, 100, plot=TRUE)    # shades
iwanthue(5, 0, 360, 0, 54, 67, 100, plot=TRUE)   # pastel
iwanthue(5, 0, 360, 54, 180, 27, 67, plot=TRUE)  # pimp
iwanthue(5, 0, 360, 36, 180, 13, 73, plot=TRUE)  # intense
iwanthue(3, 0, 300, 60, 180, 73, 100, plot=TRUE) # fluoro
iwanthue(3, 220, 260, 12, 150, 0, 53, plot=TRUE) # blue ocean
}
\references{
\itemize{
\item Examples follow those presented at \href{http://tools.medialab.sciences-po.fr/iwanthue/}{iwanthue - colors for data scientists}
\item \href{https://github.com/medialab/iwanthue}{iwanthue on GitHub}
}
}
\seealso{
\link{swatch}
}
