% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Freeboard.R
\name{freeboard}
\alias{freeboard}
\title{Freeboard Calculation}
\usage{
freeboard(v, h, sigma_wz = 0, fw = TRUE, fv = FALSE, ft = 0, min = 0,
  max = Inf, fe_fixed = 0)
}
\arguments{
\item{v}{Flow velocity [m/s].}

\item{h}{Flow depth [m].}

\item{sigma_wz}{Uncertainty in bed elevation (morphodynamics) [m].}

\item{fw}{Logical; considers freeboard due to uncertainty in water elevation.
If `TRUE`, calculates according to KOHS; if `FALSE`, sets `fw = 0`.}

\item{fv}{Logical; considers freeboard due to waves. If `TRUE`, calculates
according to KOHS; if `FALSE`, sets `fv = 0`.}

\item{ft}{Freeboard due to driftwood based on KOHS (2013) [m].}

\item{min}{Minimum allowable freeboard [m].}

\item{max}{Maximum allowable freeboard [m].}

\item{fe_fixed}{Fixed freeboard value to override calculations [m].}
}
\value{
A numeric value of the calculated freeboard [m].
}
\description{
Calculates the required freeboard based on the KOHS (2013)
recommendations.
}
\examples{
freeboard(h = 1.36, sigma_wz = 0.3, fv = FALSE, ft = 0) # Channel example.
freeboard(v = 4.56, h = 1.36, sigma_wz = 0.3, fv = TRUE, ft = 0) # Dam.
freeboard(v = 4.56, h = 1.36, sigma_wz = 0.3, fv = TRUE, ft = 0.5) # Bridge.
}
\references{
KOHS (2013). Freibord bei Hochwasserschutzprojekten und
  Gefahrenbeurteilungen - Empfehlungen der Kommission Hochwasserschutz KOHS.
  Wasser Energie Luft 105(1): 43-53.
}
