% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07_build_hydroMet.R
\name{build_hydroMet}
\alias{build_hydroMet}
\alias{build_hydroMet,hydroMet_BDHI-method}
\alias{build_hydroMet,hydroMet_CR2-method}
\alias{build_hydroMet,hydroMet_DGI-method}
\alias{build_hydroMet,hydroMet_IANIGLA-method}
\alias{build_hydroMet,hydroMet_compact-method}
\title{Automatically load native data files}
\usage{
build_hydroMet(
  obj,
  slot_list,
  path = NULL,
  col_names = NULL,
  start_date = NULL,
  end_date = NULL
)

\S4method{build_hydroMet}{hydroMet_BDHI}(obj, slot_list, path = NULL)

\S4method{build_hydroMet}{hydroMet_CR2}(obj, slot_list, path = NULL)

\S4method{build_hydroMet}{hydroMet_DGI}(obj, slot_list, path = NULL)

\S4method{build_hydroMet}{hydroMet_IANIGLA}(obj, slot_list, path = NULL)

\S4method{build_hydroMet}{hydroMet_compact}(
  obj,
  slot_list,
  col_names = NULL,
  start_date = NULL,
  end_date = NULL
)
}
\arguments{
\item{obj}{an \code{hydroMet_XXX} class object (see \link{create_hydroMet}).}

\item{slot_list}{a list containing (in each element) a vector string with the slot names. The name of the list elements are the native file names (e.g.: \emph{Qmd_Guido_BDHI.txt}). \bold{NOTE}: when the \code{obj} argument is of class \code{hydroMet_compact}, \code{slot_list} allows to build from multiple objects. So, in this case you have to provide a list of list: the top \code{list} contains as \code{names} the objects names (as you read them from \emph{Global Environment}); then every object (top level) contains another \code{list} with \code{slot} names as \code{names} and the column(s) number(s) to extract as numeric value. E.g.: \code{list(bdhi_obj = list(Qmd = 2, Qmm = c(2, 5)), cr2_obj = list(precip = 4) )}.}

\item{path}{string with the files directory. If not provided, the method will use the current working directory. \bold{NOTE}: this argument is harmless for an object of class \code{hydroMet_compact}.}

\item{col_names}{it just make sense if \code{'obj'} argument is of \code{hydroMet_compact} class. String vector with the names of the column output. Default value (NULL) will return expressive column names.}

\item{start_date}{it just make sense if \code{'obj'} argument is of \code{hydroMet_compact} class. String or POSIXct with the starting date to extract. You can use \code{start_date} without \code{end_date}. In this case you will subset your data from \code{start_date} till the end.}

\item{end_date}{it just make sense if \code{'obj'} argument is of \code{hydroMet_compact} class. String or POSIXct with the last date to extract. You can use \code{end_date} without \code{start_date}. In this case you will subset your data from the beginning till \code{end_date}.}
}
\value{
An S4 object of class \code{hydroMet_XXX} with the data loaded in each slot.
}
\description{
This method is the recommended one for loading your data-sets (as provided by the agency).
}
\section{Functions}{
\itemize{
\item \code{build_hydroMet,hydroMet_BDHI-method}: build up method for BDHI class

\item \code{build_hydroMet,hydroMet_CR2-method}: build up method for CR2 class

\item \code{build_hydroMet,hydroMet_DGI-method}: build up method for DGI class

\item \code{build_hydroMet,hydroMet_IANIGLA-method}: build up method for IANIGLA class

\item \code{build_hydroMet,hydroMet_compact-method}: build up method for \code{compact} class
}}

\examples{
# Path to file
dgi_path  <- system.file('extdata', package = "hydroToolkit")
file_name <- list.files(path = dgi_path, pattern = 'Toscas')

# Read Toscas
var_nom <- list(slotNames(x = 'hydroMet_DGI')[2:7])
names(var_nom) <- file_name

# Load Toscas meteo station data
toscas_dgi <- create_hydroMet(class_name = 'DGI')
toscas_dgi <- build_hydroMet(obj = toscas_dgi, slot_list = var_nom,
                 path = dgi_path)

}
