% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_serie.R
\name{fill_serie}
\alias{fill_serie}
\title{Find non-reported dates and fill them with \code{NA_real_}}
\usage{
fill_serie(df, colName, timeStep)
}
\arguments{
\item{df}{data frame with date and numeric vector as first and second column respectively.}

\item{colName}{output colname of the numeric variable, e.g.: 'Qmd(m3/s)'.}

\item{timeStep}{character with a valid time step: 'day', 'month', '4h', 'day/3', 'hour'.}
}
\value{
A data frame with missing time steps filled with NA's.
}
\description{
This function complete non-reported dates and assign \code{NA_real_} as their value.
}
\examples{
# Create a data frame
dates   <- seq.Date(from = as.Date('1990-01-01'), to = as.Date('1990-12-01'), by = 'm')
met_var <- runif(n = 12, 0, 10)

met_serie <- data.frame(dates, met_var)

# Fill serie
met_fill  <- fill_serie(df = met_serie, colName = 'Temp', timeStep = 'day')

}
