% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_DGI.R
\name{read_DGI}
\alias{read_DGI}
\title{Reads data from Departamento General de Irrigación (Mendoza - Argentina)}
\usage{
read_DGI(file, sheet = NULL, colName = NULL, range = NULL, path = NULL)
}
\arguments{
\item{file}{string with the file name ('xlsx' excel files).}

\item{sheet}{sheet to read. Either a string (the name of a sheet), or an integer (the position of the sheet). Default value is sheet one.}

\item{colName}{string with the name of the second column (as default first column is Date). If ignored first row excel names are used.}

\item{range}{string providing cell range to read. E.g.: 'A1:B75'.}

\item{path}{string with the files directory. If not provided, the function will use the current working directory.}
}
\value{
A data frame with two columns: date and variable. Gaps between dates are filled with \code{NA_real_} and duplicated rows are eliminated automatically.
}
\description{
Reads the Departamento General de Irrigacion(Mendoza - Argentina) excel sheet.
}
\examples{
# Relative path to raw data
full_path <- system.file('extdata', package = "hydroToolkit")

# Apply function
toscas_hr <- read_DGI(file = 'Toscas.xlsx', sheet = 'hr',
                colName = 'RH(\%)', path = full_path)

}
