% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypothesis-api.R
\name{search_annotations}
\alias{search_annotations}
\title{Search for annotations}
\source{
\url{https://h.readthedocs.io/en/latest/api-reference/v1/}
}
\usage{
search_annotations(
  limit = 20L,
  sort = c("updated", "created", "group", "id", "user"),
  search_after = NULL,
  offset = 0,
  order = c("desc", "asc"),
  uri = NULL,
  uri.parts = NULL,
  wildcard_uri = NULL,
  user = NULL,
  group = NULL,
  tags = NULL,
  any = NULL,
  quote = NULL,
  references = NULL,
  text = NULL,
  api_path = get_hs_host(),
  api_key = NULL
)
}
\arguments{
\item{limit}{The maximum number of annotations to return.}

\item{sort}{Available values : updated, created, group, id, user, Default: `updated`}

\item{search_after}{Define a start point for a subset (page) of annotation search results.
Example: 2023-01-01T10:00:00.000000+00:00}

\item{offset}{The number of initial annotations to skip in the result set.}

\item{order}{The order in which the results should be sorted. Default: `desc`}

\item{uri}{Limit the results to annotations matching the specific URI or equivalent URIs.
URI can be a URL (a web page address) or a URN representing another kind of resource such as
DOI (Digital Object Identifier) or a PDF fingerprint.}

\item{uri.parts}{Limit the results to annotations containing the given keyword (tokenized chunk)
in the URI.}

\item{wildcard_uri}{Limit the results to annotations whose URIs match the wildcard pattern.}

\item{user}{Limit the results to annotations made by the specified user.
Example: `user=acct:username@hypothes.is`}

\item{group}{Limit the results to annotations made in the specified group (by group ID).}

\item{tags}{Limit the results to annotations tagged with the specified value.
Example: tags=artificial,intelligence}

\item{any}{Limit the results to annotations who contain the indicated keyword in any of the
following field: `quote, tags, text, url`}

\item{quote}{Limit the results to annotations that contain this text inside the text that was annotated.}

\item{references}{Returns annotations that are replies to this parent annotation ID.}

\item{text}{Limit the results to annotations that contain this text in their textual body.}

\item{api_path}{The hypothesis API path, can be specify by `hypothesis.api.api_path` option or
`HYPOTHESIS_API_PATH` environment variable. Default: `https://hypothes.is/api/`.}

\item{api_key}{User api key, generated on the platform.}
}
\description{
Search for annotations
}
