% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilityFunctions.R
\name{getMRMCdataset}
\alias{getMRMCdataset}
\title{Import MRMC dataset from the web (https://github.com/DIDSR/iMRMC/wiki/iMRMC-Datasets)}
\usage{
getMRMCdataset(dataset = "viperObs")
}
\arguments{
\item{dataset}{Possible dataset options available:
\itemize{
  \item \strong{pilotHTT}: Breast cancer annotation data that is the aggregate of all clean data from the HTT project pilot study. https://github.com/DIDSR/HTT
  \item \strong{viperObs}: Individual observations of each reader reading each case from the FDA Validation of Imaging Premarket Evaluation and Regulation (VIPER) Study. https://github.com/DIDSR/viperData
  \item \strong{viperObs365}: Individual observations of each reader reading each case from the FDA Validation of Imaging Premarket Evaluation and Regulation (VIPER) Study, truth is based on cancer status at 365 days. https://github.com/DIDSR/viperData
  \item \strong{viperObs455}: Individual observations of each reader reading each case from the FDA Validation of Imaging Premarket Evaluation and Regulation (VIPER) Study, truth is based on cancer status at 455 days. https://github.com/DIDSR/viperData
  \item \strong{MFcounts_dfClassify}: A data frame comparing mitotic figure counting performance based on whole slide images (WSI images) from four scanners to the counts from a microscope, data is per  candidate mitotic figure and modality. https://github.com/DIDSR/mitoticFigureCounts/tree/master
  \item \strong{MFcounts_dfCountROI}: A data frame comparing mitotic figure counting performance based on whole slide images (WSI images) from four scanners to the counts from a microscope, data is per ROI and modality. https://github.com/DIDSR/mitoticFigureCounts/tree/master
  \item \strong{MFcounts_dfCountWSI}: A data frame comparing mitotic figure counting performance based on whole slide images (WSI images) from four scanners to the counts from a microscope, data is per WSI and modality. https://github.com/DIDSR/mitoticFigureCounts/tree/master
  \item \strong{cardioStudyTruth}: Cardio CT data comparing display color scale effects on diagnostic performance and reader agreement, ground truth data. https://github.com/DIDSR/colorScaleStudyData
  \item \strong{cardioStudyRawData}: Cardio CT data comparing display color scale effects on diagnostic performance and reader agreement, reader data. https://github.com/DIDSR/colorScaleStudyData
  \item \strong{prostateTruth}: Prostate MRI data comparing display color scale effects on diagnostic performance and reader agreement, ground truth data. https://github.com/DIDSR/colorScaleStudyData
  \item \strong{prostateRawData}: Prostate MRI data comparing display color scale effects on diagnostic performance and reader agreement, reader data. https://github.com/DIDSR/colorScaleStudyData
}}
}
\value{
desired dataset downloaded from the web as a csv
}
\description{
Import MRMC dataset from the web (https://github.com/DIDSR/iMRMC/wiki/iMRMC-Datasets)
}
\examples{
# Save Prostate MRI ground truth and reader data
truthData <- getMRMCdataset("prostateTruth")
rawData <- getMRMCdataset("prostateRawData")
}
