% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MainFun.r
\name{DataInfobeta3D}
\alias{DataInfobeta3D}
\title{Data information for reference samples}
\usage{
DataInfobeta3D(
  data,
  diversity = "TD",
  datatype = "abundance",
  PDtree = NULL,
  PDreftime = NULL,
  FDdistM = NULL,
  FDtype = "AUC",
  FDtau = NULL
)
}
\arguments{
\item{data}{(a) For \code{datatype = "abundance"}, species abundance data for a single dataset can be input as a \code{matrix/data.frame} (species-by-assemblage); data for multiple datasets can be input as a \code{list} of \code{matrices/data.frames}, with each matrix representing a species-by-assemblage abundance matrix for one of the datasets.\cr
(b) For \code{datatype = "incidence_raw"}, data for a single dataset with N assemblages can be input as a \code{list} of \code{matrices/data.frames}, with each matrix representing a species-by-sampling-unit incidence matrix for one of the assemblages; data for multiple datasets can be input as multiple lists.}

\item{diversity}{selection of diversity type: \code{'TD'} = Taxonomic diversity, \code{'PD'} = Phylogenetic diversity, and \code{'FD'} = Functional diversity.}

\item{datatype}{data type of input data: individual-based abundance data (\code{datatype = "abundance"}) or species by sampling-units incidence/occurrence matrix (\code{datatype = "incidence_raw"}) with all entries being 0 (non-detection) or 1 (detection).}

\item{PDtree}{(required argument for \code{diversity = "PD"}), a phylogenetic tree in Newick format for all observed species in the pooled assemblage.}

\item{PDreftime}{(argument only for \code{diversity = "PD"}), a numerical value specifying reference time for PD. Default is \code{PDreftime = NULL} (i.e., the age of the root of \code{PDtree}).}

\item{FDdistM}{(required argument for \code{diversity = "FD"}), a species pairwise distance matrix for all species in the pooled assemblage.}

\item{FDtype}{(argument only for \code{diversity = "FD"}), select FD type: \code{FDtype = "tau_value"} for FD under a specified threshold value, or \code{FDtype = "AUC"} (area under the curve of tau-profile) for an overall FD which integrates all threshold values between zero and one. Default is \code{FDtype = "AUC"}.}

\item{FDtau}{(argument only for \code{diversity = "FD"} and \code{FDtype = "tau_value"}), a numerical value between 0 and
1 specifying the tau value (threshold level) that will be used to compute FD. If \code{FDtype = NULL} (default), 
then threshold level is set to be the mean distance between any two individuals randomly selected from the pooled 
dataset (i.e., quadratic entropy).}
}
\value{
a data.frame including basic data information.\cr\cr 
For abundance data, basic information shared by TD, mean-PD and FD
 includes dataset name (\code{Dataset}), individual/pooled/joint assemblage (\code{Assemblage}),
sample size (\code{n}), observed species richness (\code{S.obs}), sample coverage estimates of the reference sample (\code{SC(n)}), 
sample coverage estimate for twice the reference sample size (\code{SC(2n)}). Other additional information is given below.\cr\cr
(1) TD: the first five species abundance frequency counts in the reference sample (\code{f1}--\code{f5}).\cr\cr
(2) Mean-PD: the the observed total branch length in the phylogenetic tree (\code{PD.obs}), 
the number of singletons (\code{f1*}) and doubletons (\code{f2*}) in the node/branch abundance set, as well as the total branch length 
of those singletons (\code{g1}) and of those doubletons (\code{g2}), and the reference time (\code{Reftime}).\cr\cr
(3) FD (\code{FDtype = "AUC"}): the minimum distance (\code{dmin}) and the maximum distance (\code{dmax}) among all non-diagonal elements in the distance matrix, 
and the mean distance between any two individuals randomly selected from the dataset (\code{dmean}).\cr\cr
(4) FD (\code{FDtype = "tau_value"}): the number of singletons (\code{a1*}) and of doubletons (\code{a2*}) among the functionally indistinct
 set at the specified threshold level \code{'Tau'}, as well as the total contribution of singletons (\code{h1}) and of doubletons (\code{h2})
  at the specified threshold level \code{'Tau'}.\cr\cr
 
 For incidence data, the basic information for TD includes dataset name (\code{Dataset}), individual/pooled/joint assemblage 
 (\code{Assemblage}), number of sampling units (\code{T}), total number of incidences (\code{U}), observed species richness (\code{S.obs}), 
 sample coverage estimates of the reference sample (\code{SC(T)}), sample coverage estimate for twice the reference sample size
 (\code{SC(2T)}), as well as the first five species incidence frequency counts (\code{Q1}--\code{Q5}) in the reference sample. For mean-PD and FD, output is similar to that
 for abundance data.
}
\description{
\code{DataInfobeta3D} provides basic data information for (1) the reference sample in each assemblage, 
(2) the gamma reference sample in the pooled assemblage, and (3) the alpha reference sample in the
 joint assemblage for TD, PD and FD.
}
\examples{
## (Data Information) Taxonomic diversity for abundance data
data(Brazil_rainforests)
info_TD_abun = DataInfobeta3D(data = Brazil_rainforests, diversity = 'TD', datatype = 'abundance')
info_TD_abun


## (Data Information) Taxonomic diversity for incidence data
data(Second_growth_forests)
info_TD_inci = DataInfobeta3D(data = Second_growth_forests, diversity = 'TD',
                              datatype = 'incidence_raw')
info_TD_inci

\donttest{
## (Data Information) Mean phylogenetic diversity for abundance data
data(Brazil_rainforests)
data(Brazil_tree)
info_PD_abun = DataInfobeta3D(data = Brazil_rainforests, diversity = 'PD', 
                              datatype = 'abundance', PDtree = Brazil_tree, PDreftime = NULL)
info_PD_abun
}

## (Data Information) Functional diversity for abundance data under a specified threshold level
data(Brazil_rainforests)
data(Brazil_distM)
info_FDtau_abun = DataInfobeta3D(data = Brazil_rainforests, diversity = 'FD', 
                                 datatype = 'abundance', FDdistM = Brazil_distM, 
                                 FDtype = 'tau_value', FDtau = NULL)
info_FDtau_abun


## (Data Information) Functional diversity for abundance data when all threshold levels
## from 0 to 1 are considered
data(Brazil_rainforests)
data(Brazil_distM)
info_FDAUC_abun = DataInfobeta3D(data = Brazil_rainforests, diversity = 'FD', 
                                 datatype = 'abundance', FDdistM = Brazil_distM, FDtype = 'AUC')
info_FDAUC_abun


}
