% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rewardestimation.R
\name{fit_predict.categorical_reward_estimator}
\alias{fit_predict.categorical_reward_estimator}
\title{Fit a categorical reward estimator on features, treatments and
outcomes and return predicted counterfactual rewards for each observation,
under each treatment observed in the data, as well as the scores of the
internal estimators.}
\usage{
\method{fit_predict}{categorical_reward_estimator}(obj, X, treatments, ...)
}
\arguments{
\item{obj}{The learner or grid to use for estimation}

\item{X}{The features of the data.}

\item{treatments}{The treatment applied to each point in the data.}

\item{...}{Additional arguments depending on the treatment and outcome types.
Refer to the Julia documentation for more information.}
}
\description{
Julia Equivalent:
\href{https://docs.interpretable.ai/v3.2.2/RewardEstimation/reference/#IAI.fit_predict\%21-Tuple\%7BCategoricalRewardEstimator\%7D}{\code{IAI.fit_predict!}}
}
\section{IAI Compatibility}{

Requires IAI version 2.0 or higher.
}

\examples{
\dontrun{iai::fit_predict(obj, X, treatments, outcomes)}

}
