% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimalfeatureselection.R
\name{predict.optimal_feature_selection_learner}
\alias{predict.optimal_feature_selection_learner}
\title{Return the predictions made by an Optimal Feature Selection learner for each
point in the features}
\usage{
\method{predict}{optimal_feature_selection_learner}(obj, X, fit_index = NULL, ...)
}
\arguments{
\item{obj}{The learner or grid to use for prediction.}

\item{X}{The features of the data.}

\item{fit_index}{The index of the cluster to use for prediction, if the
\code{coordinated_sparsity} parameter on the learner is
\code{TRUE}.}

\item{...}{Refer to the Julia documentation for available parameters.}
}
\description{
Julia Equivalent:
\href{https://docs.interpretable.ai/v3.2.2/OptimalFeatureSelection/reference/#IAI.predict-Tuple\%7BOptimalFeatureSelectionLearner\%2C\%20Union\%7BDataFrames.AbstractDataFrame\%2C\%20AbstractMatrix\%7B\%3C\%3AReal\%7D\%7D\%7D}{\code{IAI.predict}}
}
\section{IAI Compatibility}{

Requires IAI version 1.1 or higher.
}

\examples{
\dontrun{iai::predict(lnr, X)}

}
