% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icesAdvice-package.R
\docType{package}
\name{icesAdvice-package}
\alias{icesAdvice-package}
\alias{icesAdvice}
\title{Functions Related to ICES Advice}
\description{
A collection of functions that facilitate computational steps related to
advice for fisheries management, according to ICES guidelines. These include
methods for calculating reference points and model diagnostics.
}
\details{
\emph{Calculate ICES advice:}
\tabular{ll}{
  \code{\link{DLS3.2}}    \tab DLS method 3.2\cr
  \code{\link{icesRound}} \tab rounding method
}
\emph{Calculate PA reference points and sigma:}
\tabular{ll}{
  \code{\link{Bpa}} \tab from Blim\cr
  \code{\link{Fpa}} \tab from Flim\cr
  \code{\link{sigmaCI}} \tab from confidence interval\cr
  \code{\link{sigmaPA}} \tab from PA reference points
}
\emph{Other calculations:}
\tabular{ll}{
  \code{\link{agesFbar}} \tab suitable age range for Fbar\cr
  \code{\link{mohn}}     \tab Mohn's rho retrospective diagnosis
}
\emph{Read and write files:}
\tabular{ll}{
  \code{\link{read.dls}}  \tab read \code{DLS3.2} results from file\cr
  \code{\link{write.dls}} \tab write \code{DLS3.2} results to file
}
\emph{Example tables:}
\tabular{ll}{
  \code{\link{gss}}   \tab Greater silver smelt catch at age\cr
  \code{\link{shake}} \tab Southern hake retro
}
}
\references{
ICES advice: \url{https://ices.dk/advice}
}
\author{
Arni Magnusson, Colin Millar, and Anne Cooper.
}
