% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iclogcondist_functions.R
\name{get_F_at_x.iclogcondist}
\alias{get_F_at_x.iclogcondist}
\title{Evaluate F(x) for Objects of Class 'iclogcondist'}
\usage{
\method{get_F_at_x}{iclogcondist}(object, x = NA, log = FALSE, ...)
}
\arguments{
\item{object}{An object of class \code{iclogcondist}. Must also belong to one of the subclasses:
\code{"ic_LCMLE"}, \code{"ic_LCM_UMLE"}, or \code{"ic_UMLE"}.}

\item{x}{A numeric vector of values at which \eqn{F(x)} is evaluated. If not specified,
the \code{tau_no_Inf} attribute of the \code{object} object is used.}

\item{log}{Logical; if \code{TRUE}, returns the result in log-transformed form.
Default is \code{FALSE}.}

\item{...}{Additional arguments (not currently used).}
}
\value{
A numeric vector of values, either \eqn{F(x)} or \eqn{log(F(x))}.
}
\description{
Computes the value of the function \eqn{F(x)} for a given object of class \code{iclogcondist}.
}
\examples{
# Example usage:
data(lgnm)

# Evaluate for LCMLE object
fit_LCMLE <- ic_LCMLE(lgnm)
get_F_at_x(fit_LCMLE)

# Evaluate for UMLE object
fit_UMLE <- ic_UMLE(lgnm)
x = seq(0.001, 6, length.out = 1000)
get_F_at_x(fit_UMLE, x = x)
}
