% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-rgl-grid.R
\name{gridlabs3d}
\alias{gridlabs3d}
\alias{gridlabs3d,trigrid-method}
\alias{gridlabs3d,hexagrid-method}
\title{Display the names of the grid elements in 3d plots.}
\usage{
gridlabs3d(gridObj, ...)

\S4method{gridlabs3d}{trigrid}(gridObj, type = "f", ...)

\S4method{gridlabs3d}{hexagrid}(gridObj, type = "f", ...)
}
\arguments{
\item{gridObj}{(\code{\link{trigrid}}, \code{\link{hexagrid}}) An icosahedral grid.}

\item{...}{Additional arguments passed to \code{\link[rgl:texts]{text3d}} function of the \code{rgl} package.}

\item{type}{(\code{character}) Vector containing either \code{"f"}, \code{"e"} or \code{"v"}, rendering the names
of either the faces, edges or vertives respectively.}
}
\value{
The function does not return any value.
}
\description{
This function will display the names of vertices, faces and edges on 3d plots.
}
\examples{
# create a hexagonal grid
g <- hexagrid(c(2,2))
# plot the grid in 3d space
# lines3d(g, guides=FALSE)
# labels
# gridlabs3d(g)
}
