% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_icfit.R
\name{plot.icfit}
\alias{plot.icfit}
\title{Plot method for an object of class `icfit`}
\usage{
\method{plot}{icfit}(
  x,
  type = c("hazard", "cumhazard", "survival", "probability"),
  conf.int = TRUE,
  ylim = NULL,
  title = NULL,
  xlab = NULL,
  ylab = NULL,
  fill = TRUE,
  fillcol = "lightgrey",
  ...
)
}
\arguments{
\item{x}{The object of class 'icfit' to be plotted}

\item{type}{Type of plot. Accepted choices: 'hazard' (default), 'cumhazard', 'survival' or 'cumprob'}

\item{conf.int}{If `TRUE` a 100*(1 - alpha) percent confidence interval is plotted}

\item{ylim}{The y-limits for the plot}

\item{title}{Optional title string}

\item{xlab}{Text for x-label}

\item{ylab}{Text for y-label}

\item{fill}{Fill area between lower and upper}

\item{fillcol}{The color for filling (default 'lightgrey')}

\item{\dots}{Other arguments to plot (except `type`, which is set to 'l')}
}
\value{
A ggplot grob, containing the plot. Use \code{print()} or \code{plot()} to show it
Multiple objects can be combined by using functions in the package \code{gridExtra}.
}
\description{
Plot method for an object of class `icfit`
}
\examples{
\donttest{
icf <- icfit(Surv(left, right, type='interval2') ~ period + gender + age, 
             data = drugusers)
plot(icf)
}

}
