% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gendata.r
\name{gendata}
\alias{gendata}
\title{Data generator for intrinsic dimension estimation.}
\usage{
gendata(
  DataName = "SwissRoll",
  n = 300,
  p = NULL,
  noise = NULL,
  ol = NULL,
  curv = 1,
  seed = 123,
  sorted = FALSE
)
}
\arguments{
\item{DataName}{Name of dataset, one of the following: 
\itemize{
 \item SwissRoll: SwissRoll data, 2D manifold in 3D space.
 \item NDSwissRoll: Non-deformable SwissRoll data, 2D manifold in 3D space.
 \item Moebius: Moebius strip, 2D manifold in 3D space.
 \item SphericalShell: Spherical Shell, (p-1)-dimensional manifold in p-dimensional space.
 \item Sinusoidal: Sinusoidal data, 1D manifold in 3D space.
 \item Spiral: Spiral-shaped 1D manifold in 2D space.
 \item Cylinder: Cylinder-shaped 2D manifold in 3D space.
 \item SShape: S-shaped 2D manifold in 3D space.
 \item ldbl: LDB(line - disc - filled ball - line), embedded in 3D space (original dataset).
}}

\item{n}{number of data points to be generated.}

\item{p}{ambient dimension of the dataset.}

\item{noise}{parameter to control noise level in the dataset. In many cases,
it is used for \code{sd} of \code{rnorm} used inside the function.}

\item{ol}{percentage of outliers, i.e., n * ol outliers are added to the generated dataset.}

\item{curv}{a parameter to control the complexity of the embedded manifold.}

\item{seed}{random number seed.}

\item{sorted}{logical. If \code{TRUE}, the index of the generated dataset is sorted
with respect to x-axis for the ease of visualization.}
}
\value{
Data matrix. For \code{ldbl} dataset, it outputs a list composed of
 \code{x}: data matrix and \code{tDim}: true intrinsic dimension for each point.
}
\description{
\code{gendata} generates various artificial datasets for intrinsic dimension estimation experiments.
}
\details{
This function generates various artificial datasets often used in 
manifold learning and dimension estimation researches.
For some datasets, complexity of the shape is controlled by the parameter \code{curv}.
The parameters \code{noise} and \code{outlier} are used for adding noise and/or 
outliers for the dataset.
}
\examples{
## global intrinsic dimension estimate
x <- gendata(DataName='SwissRoll')
estmle <- lbmle(x=x,k1=3,k2=5)
print(estmle)

## local intrinsic dimension estimate
tmp <- gendata(DataName='ldbl',n=1000)
x <- tmp$x
estmada <- mada(x=x,local=TRUE)
head(estmada)  ## estimated local intrinsic dimensions
head(tmp$tDim) ## true local intrinsic dimensions
}
\author{
Hideitsu Hino \email{hideitsu.hino@gmail.com}
}
