% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_idx.R
\name{write_idx}
\alias{write_idx}
\title{Write an array into an IDX file}
\usage{
write_idx(x, file_name, endian = "big")
}
\arguments{
\item{x}{must be a array or a matrix}

\item{file_name}{character vector containing the name of
the file to be created}

\item{endian}{whether the file has "big" or "little" endian.}
}
\description{
This function allows to write an array into an IDX file.
}
\examples{
m = matrix(1:16, nrow = 4)
file_name = file.path(tempdir(),"m.idx")
write_idx(m, file_name)    
}
