% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igl.R
\name{qcondigl}
\alias{qcondigl}
\alias{pcondigl}
\alias{qcondigl21}
\alias{pcondigl21}
\alias{pcondigl12}
\alias{qcondigl12}
\alias{digl}
\alias{pigl}
\alias{rigl}
\alias{logdigl}
\title{IGL Copula Family Functions}
\usage{
qcondigl(p, u, alpha)

pcondigl(v, u, alpha)

qcondigl21(p, u, alpha)

pcondigl21(v, u, alpha)

pcondigl12(u, v, alpha)

qcondigl12(p, v, alpha)

digl(u, v, alpha)

pigl(u, v, alpha)

rigl(n, alpha)

logdigl(u, v, alpha)
}
\arguments{
\item{p}{Vector of quantile levels between 0 and 1 to
evaluate a quantile function at.}

\item{u, v}{Vectors of values between 0 and 1 representing values of the first
and second copula variables.}

\item{alpha}{Single numeric >0; corresponds to parameter \code{alpha} in the
IGL copula family.}

\item{n}{Positive integer. Number of observations to randomly draw.}
}
\value{
Numeric vector of length equal to the length of the input vector(s).
}
\description{
Functions related to the IGL copula family, denoted  by \code{'igl'}.
}
\note{
Inputting two vectors greater than length 1 is allowed, if they're
the same length.
Also, \code{qcondigl21} and \code{pcondigl21} are the same as
\code{qcondigl} and \code{pcondigl} -- they are the distributions of
variable 2 given 1.
}
\examples{
set.seed(1)
u <- runif(10)
v <- runif(10)
pigl(u, v, alpha = 1)
digl(u, v, alpha = 2)
logdigl(u, v, alpha = 0.4)
pcondigl21(v, u, alpha = 6)
qcondigl21(v, u, alpha = 6)
pcondigl12(u, v, alpha = 6)
qcondigl12(u, v, alpha = 6)
rigl(10, alpha = 3)
}
