% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{create_userterms_skeleton}
\alias{create_userterms_skeleton}
\title{Generate the Skeleton for an R package to implement additional iglm terms}
\usage{
create_userterms_skeleton(path = ".", pkg_name = "iglm.userterms")
}
\arguments{
\item{path}{A character string specifying the path where the package directory
should be created. Defaults to the current working directory (\code{"."}).}

\item{pkg_name}{A character string specifying the name of the package to be created.}
}
\description{
This function generates the directory structure and source files for a new R package
named \code{iglm.userterms} (or whatever name is provided in the parameter \code{pkg_name}).
This auxiliary package serves as a template for extending the
\code{iglm} framework to user-defined sufficient statistics.
By compiling this package, users can link custom C++ implementations of change statistics
directly with the \code{iglm} package, enabling seamless integration of new model terms.
}
\details{
The function creates a directory with the name specified in \code{pkg_name}  
at the specified location.
As an example for a possible statistic, the statistic counting mutual 
connections in the network is implemented. 
After defining all possible change-statistics in the c++ function (this has to include a change for
\code{z_ij} (network), \code{x_i} (attribute x), and \code{y_i} (attribute y) all toggling from 0 to 1), 
the function has to be registered using the \code{EFFECT_REGISTER} macro.
After compiling the package,
users have to load the package using \code{library(pkg_name)} before using it in \code{iglm}.
}
