% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampler.r
\name{sampler.net.attr}
\alias{sampler.net.attr}
\title{Constructor for Single Component Sampler Settings}
\usage{
sampler.net.attr(n_proposals = 10000, seed = NA, file = NULL)
}
\arguments{
\item{n_proposals}{(integer) The number of MCMC proposals (iterations) to
perform for this specific component during each sampling update.
Default: 10000.}

\item{seed}{(integer or `NA`) An integer seed for the random number generator
to ensure reproducibility for this component's sampling process. If `NA`
(default), a random seed will be generated automatically.}

\item{file}{(character or `NULL`) If provided, loads the sampler state from
'  the specified .rds file instead of initializing from parameters.}
}
\value{
An object of class `sampler_net_attr` (and `R6`).
}
\description{
Creates an object of class `sampler_net_attr` (and `R6`). This object
specifies the MCMC sampling parameters for a single component (like an
attribute vector or a network structure) within the larger `iglm`
simulation framework. It is typically used as input when creating a
`sampler.iglm` object.
}
\examples{
# Default settings
sampler_comp_default <- sampler.net.attr()
sampler_comp_default

# Custom settings
sampler_comp_custom <- sampler.net.attr(n_proposals = 50000, seed = 123)
sampler_comp_custom
}
\seealso{
`sampler.iglm`
}
