% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testchange.R
\name{testchange}
\alias{testchange}
\title{testchange}
\usage{
testchange(data, time, perm = FALSE, nperm = 100, numclust = 4, topF = 500)
}
\arguments{
\item{data}{a numeric matrix, each row representing a time-series
and each column representing a time point}

\item{time}{defines the time sequence}

\item{perm}{if perm = 'TRUE', a permutation is performed}

\item{nperm}{number of permuations}

\item{numclust}{defines the number of clusters for the parallel processing}

\item{topF}{number of top F values to be selected when perm = 'FALSE'}
}
\value{
Output if perm = 'TRUE' is a list of three items:
\itemize{
 \item perm.F - F values obtained from permutation tests
 \item p.values - p-values obtained from permutation tests
 \item p.adjusted - p-values adjusted by Benjamini-Hochberg method
 }
 Output if perm = 'False' is a list of three items:
\itemize{
 \item obs.F - conventional F-statistic values
 \item sig.change - areas with significant change over time pattern selected by top F-statistic values
 \item sel.F - top F-statistic values selected
 }
}
\description{
This function identifies geographic areas with significant change over time.
}
\details{
number of permutations of >=10,000 is ideal
}
\examples{
# This is an example not using the permutation approach

opioid_data_noNA <- opioidData[complete.cases(opioidData), ] #remove NAs

mydata <- as.matrix(opioid_data_noNA[,4:18])

testchange_results <- testchange(data=mydata,perm=FALSE,time=seq(1,15,1))
}
\references{
1. Song, J., Carey, M., Zhu, H., Miao, H., Ram´ırez, J. C., & Wu, H. (2018). Identifying the dynamic gene regulatory network during latent HIV-1 reactivation using high-dimensional ordinary differential equations. International Journal of Computational Biology and Drug Design, 11,135-153. doi: 10.1504/IJCBDD.2018.10011910.
2. Wu, S., & Wu, H. (2013). More powerful significant testing for time course gene expression data using functional principal component analysis approaches. BMC Bioinformatics, 14:6.
3. Carey, M., Wu, S., Gan, G. & Wu, H. (2016). Correlation-based iterative clustering methods for time course data: The identification of temporal gene response modules for influenza infection in humans. Infectious Disease Modeling, 1, 28-39.
}
