% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Targets.R
\name{TargetsSpecifications}
\alias{TargetsSpecifications}
\alias{add_target}
\alias{group_targets}
\alias{define_targets}
\alias{as.targets}
\title{Specify Targets}
\usage{
add_target(
  target,
  starting_range,
  stopping_range,
  target_name = NULL,
  FUN = NULL
)

group_targets(..., group_name = NULL)

define_targets(..., target_df = NULL)

as.targets(df, ...)
}
\arguments{
\item{target}{numeric(1). The value a target function is aiming for.}

\item{starting_range}{numeric(2). The initial range of values imabc will consider as good when testing simulated parameters.}

\item{stopping_range}{numeric(2). The range of values a target function's simulated value must be within to be considered
calibrated.}

\item{target_name}{Optional character(1). The name of the target.}

\item{FUN}{Optional function. The function that takes parameters and calculated the target value. See Target Function.}

\item{...}{In group_targets: The results of add_target calls - one for each target within a grouping of targets. See
Target Groups. In define_targets: The results of add_target and/or group_target calls - one for each target or grouping
of targets. In as.targets: alternate column names for the target settings can be any one of target_names, targets,
current_lower_bounds, current_upper_bounds, stopping_lower_bounds, or stopping_upper_bounds}

\item{group_name}{Optional character(1). The name for the grouping of targets.}

\item{target_df}{Optional data.frame. Targets stored as a data.frame or from the results object of a previous run.}

\item{df}{data.frame. Each row is a target and the columns represent the different pieces of information relevant to
the targets.}
}
\value{
A targets imabc object.
}
\description{
Helper functions that can be used to create an imabc targets object used by imabc().
}
\section{Target Values}{

When specifying values the following condition must always hold true:\preformatted{starting_range[1] <= stopping_range[1] <= target <= stopping_range[2] <= starting_range[2]
}

As imabc simulates parameters, it will test them using the target function(s) against the starting range. Parameters whose
values fall within the starting range will be kept through to the next iteration and will be used to generate new parameters
for testing. As the parameters get better at falling withing the initial range, imabc will reduce the valid range of
targets to be considered. Once the current valid range matches the stopping range the algorithm will no longer reduce
the valid range of target values.
}

\section{Target Groups}{

A grouped target refers to a set of scalar targets that were gathered as part of the same study or otherwise refer to
a series of outcomes, such as outcomes reported by age, by sex, or over time (a time series). When targets are grouped
imabc will constrict the range of valid target values relative to the least improved target within the group of targets.
This lets the range of simulated parameters stay wide enough to continue improving all the targets.
}

\section{Target Names}{

The user can specify names by either specifying the input target_name in add_target or by setting the result of an
add_target call to a object in group_targets or define_targets (e.g. group_targets(t1 = add_target(...))). If the user
specifies the target_name input and sets add_target to an object, the target_name value will be used. If no name is
specified a unique name will be generated automatically.

These same rules also applies to groups of targets and the group_name input in group_targets. However, group_targets
can only be added as an input to define_targets. If a single target is added in define_targets it will not have a
group name.
}

\section{Target Function}{

There are multiple ways to specify a target function. One way is to attach it to the target object using the FUN input
in add_target. The inputs to the target function can either be a single object (e.g. function(x)) or several objects
whose name is equal to the parameter they represent (e.g. function(x1, x2)). If a single object is used, the user can
assume that a name vector with all parameters specified in the priors object will be passed to the function and the order
of the vector will be the same as the order in which they were specified with define_priors. For example, if someone
specified three parameters named x1, x3, and x2 respectively then the following specifications would all be equivalent:\preformatted{function(x1, x3) \{ x1 + x3 \} == function(x) \{ x["x1"] + x["x3"] \} == function(x) \{ x[1] + x[2] \}
}

Additionally, for more complex situations the user may also reference the targets object and priors object within a
target function but they must specify them as inputs (e.g. function(x, targets, priors)) and use the objects as they
exist within those objects. See define_target_function for more details and other ways to specify the target function.
}

\examples{
add_target(target = 0.5, starting_range = c(0.2, 0.9), stopping_range = c(0.48, 0.51))
add_target(
  target = 1.5, starting_range = c(1.0, 2.0), stopping_range = c(1.49, 1.51),
  FUN = function(x1, x2) { x1 + x2 + rnorm(1, 0, 0.01) }
)

group_targets(
  targ1 = add_target(target = 0.5, starting_range = c(0.2, 0.9), stopping_range = c(0.48, 0.51)),
  add_target(
    target_name = "targ2",
    target = 1.5, starting_range = c(1.0, 2.0), stopping_range = c(1.49, 1.51),
    FUN = function(x1, x2) { x1 + x2 + rnorm(1, 0, 0.01) }
  )
)
define_targets(
  group1 = group_targets(
    targ1 = add_target(target = 0.5, starting_range = c(0.2, 0.9), stopping_range = c(0.48, 0.51)),
    add_target(
      target_name = "targ2",
      target = 1.5, starting_range = c(1.0, 2.0), stopping_range = c(1.49, 1.51)
    )
  ),
  targ3 = add_target(target = 1, starting_range = c(0.2, 1.9), stopping_range = c(0.9, 1.1))
)

df <- data.frame(
  target_groups = c("G1", "G1", NA),
  target_names = c("T1", "T3", "T2"),
  targets = c(1.5, 0.5, -1.5),
  current_lower_bounds = c(1, 0.2, -2),
  current_upper_bounds = c(2, 0.9, -1),
  stopping_lower_bounds = c(1.49, 0.49, -1.51),
  stopping_upper_bounds = c(1.51, 0.51, -1.49)
)
as.targets(df)

}
