% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/typicality.R
\name{img_typicality}
\alias{img_typicality}
\title{Typicality of images relative to each other}
\usage{
img_typicality(imglist, rescale = NULL)
}
\arguments{
\item{imglist}{A \emph{list} of arrays or matrices with numeric values. Use
e.g. \code{\link{img_read}()} to read image files into \code{R} (see
example).}

\item{rescale}{numeric. Rescales the images prior to computing the typicality
scores (per default no rescaling is performed). Rescaling is performed by
\code{OpenImageR}'s \code{\link[OpenImageR]{resizeImage}} function
(bilinear rescaling)}
}
\value{
a named matrix of numeric values (typicality scores)
}
\description{
\code{img_typicality} returns the visual typicality of a list of images
relative to each other. Higher values indicate larger typicality.
}
\details{
The function returns the visual typicality of a \emph{list} of image
  arrays or matrices \code{imglist} relative to each other. Values can range
  between -1 (inversely typical) over 0 (not typical) to 1 (perfectly typical).
  That is, higher absolute values indicate a larger typicality.

  The typicality score is computed as the correlation of a particular image
  with the average representation of all images, i.e. the mean of all images.
  For color images, the weighted average between each color channel's values
  is computed. If the images have different dimensions they are automatically
  resized to the smallest height and width.

  Rescaling of the images prior to computing the typicality scores can be
  specified with the optional rescaling parameter (must be a numeric value).
  Most users won't need any rescaling and can use the default (\code{rescale
  = NULL}). See Mayer & Landwehr (2018) for more details.
}
\examples{
# Example images depicting valleys: valley_green, valley_white
# Example image depicting fireworks: fireworks
valley_green <- img_read(
    system.file("example_images", "valley_green.jpg", package = "imagefluency")
  )
valley_white <- img_read(
    system.file("example_images", "valley_white.jpg", package = "imagefluency")
  )
fireworks <- img_read(
    system.file("example_images", "fireworks.jpg", package = "imagefluency")
  )
#
# display images
grid::grid.raster(valley_green)
grid::grid.raster(valley_white)
grid::grid.raster(fireworks)

# create image set as list
imglist <- list(fireworks, valley_green, valley_white)

# get typicality
img_typicality(imglist)

}
\references{
Mayer, S. & Landwehr, J. R. (2018). Objective measures of design
  typicality. \emph{Design Studies}, \emph{54}, 146--161.
  \doi{10.1016/j.destud.2017.09.004}
}
\seealso{
\code{\link{img_read}}, \code{\link{img_contrast}},
   \code{\link{img_complexity}}, \code{\link{img_self_similarity}}
  \code{\link{img_simplicity}}, \code{\link{img_symmetry}}
}
