% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weo_get_series.R
\name{weo_get_series}
\alias{weo_get_series}
\title{Get Available WEO Series}
\usage{
weo_get_series(year = NULL, release = NULL, quiet = TRUE)
}
\arguments{
\item{year}{The year of a WEO publication (e.g., 2024). Defaults to latest
publication year.}

\item{release}{The release of a WEO publication ("Spring" or "Fall").
Defaults to latest publication release.}

\item{quiet}{A logical indicating whether to print download information.
Defaults to TRUE.}
}
\value{
A data frame with columns:
\describe{
\item{series_id}{The WEO series ID (e.g., "NGDP_RPCH")}
\item{series_name}{Full name of the series (e.g., "Gross domestic product,
constant prices")}
\item{units}{Units of measurement}
}
}
\description{
Returns a data frame with available series in the WEO database.
}
\examples{
\dontshow{if (curl::has_internet()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# List all series
weo_get_series()
}
\dontshow{\}) # examplesIf}
}
