% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v0_overlap_analysis.R
\name{repOverlapAnalysis}
\alias{repOverlapAnalysis}
\title{Post-analysis of public clonotype statistics: PCA, clustering, etc.}
\usage{
repOverlapAnalysis(
  .data,
  .method = ("hclust"),
  .scale = default_scale_fun,
  .raw = TRUE,
  .perp = 1,
  .theta = 0.1,
  .eps = 0.01,
  .k = 2
)
}
\arguments{
\item{.data}{Any distance matrix between pairs of repertoires. You can also pass your
output from \code{\link[=repOverlap]{repOverlap()}}.}

\item{.method}{A string that defines the type of analysis to perform.}

\item{.scale}{A function to scale the data before passing it to the MDS algorithm.}

\item{.raw}{A logical value. Set TRUE if you want to receive raw output of clustering
or dimensionality reduction function of choice. Set FALSE if you want to receive
processed output that can be subjected to visualisation with \code{\link[=vis]{vis()}} function.}

\item{.perp}{A numerical value, t-SNE parameter, see \code{\link[=immunr_tsne]{immunr_tsne()}}.}

\item{.theta}{A numerical value, t-SNE parameter, see \code{\link[=immunr_tsne]{immunr_tsne()}}.}

\item{.eps}{A numerical value, DBscan epsylon parameter, see \code{\link[=immunr_dbscan]{immunr_dbscan()}}.}

\item{.k}{The number of clusters to create, passed as \code{k} to \link[factoextra:hcut]{hcut} or as \code{centers} to \link{kmeans}.}
}
\value{
Depends on the last element in the \code{.method} string. See \link{immunr_tsne} for more info.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

The \code{\link[=repOverlapAnalysis]{repOverlapAnalysis()}} function contains advanced data
analysis methods. You can use several clustering and dimensionality reduction
techniques in order to investigate further the difference between repertoires
provided.

To cluster a subset of similar data with \code{\link[=repOverlapAnalysis]{repOverlapAnalysis()}} you can
perform hierarchical clustering, k-means or dbscan ('hclust', 'kmeans', 'dbscan'
respectively).

To reduce dimensions, for example, to select features for subsequent analysis,
you can execute the multidimensional scaling or t-sne algorithms ('mds' and 'tsne'
respectively).
}
\examples{
data(immdata)
ov <- repOverlap(immdata$data)
repOverlapAnalysis(ov, "mds+hclust") \%>\% vis()
}
\concept{overlap}
