% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balancePlot.R
\name{balancePlot}
\alias{balancePlot}
\title{Create a Baseline Balance Plot.}
\usage{
balancePlot(data)
}
\arguments{
\item{data}{tibble produced with \code{checkBaseline}.}
}
\value{
ggplot2 baseline balance plot.
}
\description{
Create a Baseline Balance Plot.
}
\examples{
\donttest{
library(imt)
set.seed(123)  # for reproducibility
N <- 1000
fake_data <- tibble::tibble(x1 = rnorm(N), x2 = rnorm(N), t = rbinom(N, 1, 0.5))
baseline <- checkBaseline(data = fake_data, variables = c("x1", "x2"), treatment = "t")
balancePlot(data = baseline)
}
}
