% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkBaseline.R
\name{calculateEffectSizes}
\alias{calculateEffectSizes}
\title{Calculate Effect Sizes for Treatment vs. Control}
\usage{
calculateEffectSizes(data, treatment_column, to_check = NULL)
}
\arguments{
\item{data}{A data frame containing the variables and treatment/control indicator.}

\item{treatment_column}{The name of the column (as a string) in the data frame that 
  indicates whether an observation is in the treatment or control group. This column 
  must be a factor with exactly two levels.}

\item{to_check}{(optional) A character vector specifying the names of the
variables for which effect sizes should be calculated. If NULL (default),
all variables (except the treatment column) are processed.}
}
\value{
A data frame with two columns:
  * \code{Variable}: The name of each variable in the original data frame.
  * \code{EffectSize}: The calculated effect size for each variable.
}
\description{
This function calculates effect sizes for each variable in a data frame, 
comparing treatment and control groups. It handles continuous, binary, 
and categorical variables using appropriate effect size measures.
}
\details{
- For continuous variables, Hedges' g effect size is calculated.
  - For binary variables, Cox's Proportional Hazards Index (Cox's C) is calculated.
  - For categorical variables, the variable is converted into multiple indicator 
   (dummy) variables, and the average Cox's C across these indicators is reported.
}
