% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UpsetjsPlot.R
\name{UpsetjsPlot}
\alias{UpsetjsPlot}
\title{UpsetjsPlot}
\usage{
UpsetjsPlot(
  WD_samples,
  Th_logFC,
  Th_Pvalue,
  collapseName,
  nintersects,
  st_significance
)
}
\arguments{
\item{WD_samples}{Character. Directory containing DEG result CSV files.}

\item{Th_logFC}{Numeric. Absolute log2 fold-change threshold to include a gene.}

\item{Th_Pvalue}{Numeric. P-value threshold for significance (0 < Th_Pvalue <= 1).}

\item{collapseName}{Logical. If TRUE, strip method/model prefixes from file names when labeling sets.}

\item{nintersects}{Integer. Maximum number of intersections to display.}

\item{st_significance}{Character. Which p-value to use: "adjustPvalue" (FDR or FWER) or "PValue".}
}
\value{
An interactive "UpsetJS" object.
}
\description{
Create an interactive UpSet plot of overlapping DEGs using "UpsetJS".
}
\details{
This function reads DEG CSV files from a directory, filters genes by log-FC and
p-value thresholds (adjusted or raw), optionally simplifies file names, and
visualizes the intersections of gene sets using the "UpsetJS" package.
\enumerate{
\item Lists all CSV files in "WD_samples" and reads each into a data frame.
\item Checks for duplicate IDs and selects "ID", "logFC", and either "adjustPvalue" or "PValue".
\item Filters each set by "|logFC| >= Th_logFC" and p-value < "Th_Pvalue".
\item Renames each gene-ID list to the (optionally collapsed) file name.
\item Feeds the list of gene sets into "upsetjs::upsetjs()"
}
}
