#ifndef LOGCOSH_HPP
#define LOGCOSH_HPP

#include <RcppArmadillo.h>

namespace Logcosh {

    double ff(const colvec& ee) {
        colvec eep = exp(ee);
        colvec eem = 1.0 / eep;
        eep = log(0.5 * (eem + eep));
        return sum(eep);
     }

    template <typename T> colvec ffGrd(const T& A, const colvec& ee) {
        colvec eep = exp(ee);
        colvec eem = 1.0 / eep;
        colvec grd = -A.t() * ((eep - eem) / (eem + eep));
        return grd;
    }

}

namespace aLogcosh {

    double ff(const colvec& ee,const colvec& lambda) {
        colvec eep = exp(ee % lambda);
        colvec eem = 1.0 / eep;
        eep = log(0.5 * (eem + eep));
        return sum(eep);
     }

    template <typename T> colvec ffGrd(const T& A, const colvec& ee, const colvec& lambda) {
        colvec eep = exp(ee % lambda);
        colvec eem = 1.0 / eep;
        colvec grd = -A.t() * ((lambda / (eem + eep)) % (eep - eem));
        return grd;
    }

}

namespace rLogcosh {

    double ff(const colvec& ee, const colvec& scale) {
        colvec eep = exp(ee % scale);
        colvec eem = 1.0 / eep;
        eep = log(0.5 * (eem + eep));
        return sum(eep);
    }

    template <typename T> colvec ffGrd(const T& A, const colvec& ee, const colvec& scale) {
        colvec eep = exp(ee % scale);
        colvec eem = 1.0 / eep;
        colvec grd = -A.t() * ((scale / (eem + eep)) % (eep - eem));
        return grd;
    }

}

#endif // LOGCOSH_HPP
