#ifndef SUMEXP_HPP
#define SUMEXP_HPP

#include <RcppArmadillo.h>

namespace Sumexp {

    double ff(const colvec& ee) {
        colvec eep = exp(abs(ee));
        return sum(eep);
     }

    template <typename T> colvec ffGrd(const T& A, const colvec& ee) {
        colvec eep = exp(abs(ee));
        colvec ees = sign(ee);
        colvec grd = -A.t() * (eep % ees);
        return grd;
    }

}

namespace aSumexp {

    double ff(const colvec& ee,const colvec& lambda) {
        colvec eep = exp(ee % lambda);
        return sum(eep);
     }

    template <typename T> colvec ffGrd(const T& A, const colvec& ee, const colvec& lambda) {
        colvec eep = exp(ee % lambda);
        colvec grd = -A.t() * (eep % lambda);
        return grd;
    }

}

namespace rSumexp {

    double ff(const colvec& ee, const colvec& scale) {
        colvec eep = exp(abs(ee) % scale);
        return sum(eep);
    }

    template <typename T> colvec ffGrd(const T& A, const colvec& ee, const colvec& scale) {
        colvec eep = exp(abs(ee) % scale);
        colvec ees = sign(ee);
        colvec grd = -A.t() * (eep % scale % ees);
        return grd;
    }

}

#endif // SUMEXP_HPP
