#ifndef MODREHUBER_HPP
#define MODREHUBER_HPP

#include <RcppArmadillo.h>

namespace modrehuber {

    using namespace arma;

    double pen(const colvec& adjwt, const colvec& wt) {
        size_t i;
        colvec df = abs(1.0 - adjwt / wt);
        for (i = 0; i < df.size(); i++) {
            if (df[i] < 1.0) df[i] *= df[i];
        }
        return sum(df);
    }

    colvec penGrd(const colvec& adjwt, const colvec& wt) {
        size_t i;
        colvec df = adjwt / wt;
        colvec dv = abs(df - 1.0);
        for (i = 0; i < dv.size(); i++) {
            if (dv[i] < 1.0) {
                dv[i] *= 2.0 / wt[i];
            }
            else {
                dv[i] = 1.0 / wt[i];
            }
        }
        return sign(df - 1.0) % dv;
    }

}

#endif // MODREHUBER_HPP
