#ifndef SCAD_HPP
#define SCAD_HPP

#include <RcppArmadillo.h>

namespace scad {

    using namespace arma;

    double pen(const colvec& adjwt, const colvec& wt, double lambda) {
        size_t i;
        double df, den, gamma, res = 0.0;
        
        for (i = 0; i < wt.size(); i++) {
            df = fabs(wt[i] - adjwt[i]);
            gamma = (double) (wt[i] < 2.0) * 2.0 + (double) (wt[i] >= 2.0) * wt[i];
            if (df <= lambda) {
                res += lambda * df;
            }
            else {
                if (df < gamma * lambda) {
                    den = 2.0 * gamma * lambda * df - gamma * gamma - lambda * lambda;
                    den /= 2.0 * (gamma - 1.0);
                    res += den;
                } 
                else {
                    res += lambda * lambda * (gamma + 1.0) * 0.5;
                }
            }
        }        
        return res;
    }

    colvec penGrd(const colvec& adjwt, const colvec& wt, double lambda) {
        size_t i;
        double df, ad, gamma;
        colvec grd = sign(adjwt - wt);
        for (i = 0; i < grd.size(); i++) {
            df = wt[i] - adjwt[i];
            ad = fabs(df);
            gamma = (double) (wt[i] < 2.0) * 2.0 + (double) (wt[i] >= 2.0) * wt[i];
            if (ad <= lambda) {
                grd[i] *= lambda;
            }
            else {
                if (ad < gamma * lambda) {
                    grd[i] *= gamma * lambda - ad;
                    grd[i] /= gamma - 1.0;
                } 
                else {
                    grd[i] = 0.0;
                }
            }
        }
        return grd;
    }

}

#endif // SCAD_HPP
