% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/in_case_list.R
\name{in_case_list}
\alias{in_case_list}
\alias{switch_case_list}
\alias{grep_case_list}
\alias{fn_case_list}
\alias{fn_switch_case_list}
\title{Case statements returning a list}
\usage{
in_case_list(
  ...,
  .preserve = FALSE,
  .default = NA,
  preserve = deprecated(),
  default = deprecated()
)

switch_case_list(
  x,
  ...,
  .preserve = FALSE,
  .default = NA,
  .exhaustive = FALSE,
  preserve = deprecated(),
  default = deprecated()
)

grep_case_list(
  x,
  ...,
  .preserve = FALSE,
  .default = NA,
  .exhaustive = FALSE,
  preserve = deprecated(),
  default = deprecated()
)

fn_case_list(
  x,
  fn,
  ...,
  .preserve = FALSE,
  .default = NA,
  .exhaustive = FALSE,
  preserve = deprecated(),
  default = deprecated()
)

fn_switch_case_list(
  x,
  fn,
  ...,
  .preserve = FALSE,
  .default = NA,
  .exhaustive = FALSE,
  preserve = deprecated(),
  default = deprecated()
)
}
\arguments{
\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> A sequence of two-sided
formulas or named arguments.
\itemize{
\item \strong{Formulas}: Elements of \code{x} that return \code{TRUE} when passed to \code{fn} with
the left hand side (LHS) of each formula will be replaced with the value in
the right hand side (RHS).
The LHS must evaluate to a logical vector when passed to \code{fn} with \code{x}.
The RHS must be of length 1 or the same length as all other RHS.
\item \strong{Named arguments}: named arguments are passed as additional arguments
to the function \code{fn}.
}}

\item{.preserve, preserve}{If \code{TRUE}, unmatched elements of \code{x} will be returned
unmodified.
(The elements may have their type coerced to be compatible with
replacement values.)
If \code{FALSE}, unmatched elements of \code{x} will be replaced with \code{.default}.
Defaults to \code{FALSE}.}

\item{.default, default}{If \code{.preserve} is \code{FALSE}, a value to replace unmatched
elements of \code{x}.
Defaults to \code{NA}.}

\item{x}{A vector}

\item{.exhaustive}{If \code{TRUE}, unmatched elements of \code{x} will result in
an error.
This can be useful to ensure you aren't accidentally forgetting to recode
any values.
Defaults to \code{FALSE}.

Note that if \code{.preserve} is \code{TRUE},
\code{.exhaustive} will never have any effect.}

\item{fn}{A function to apply to the left-hand side of each formula in \code{...}

Either a quoted or unquoted function name, an anonymous \code{\link{function}}, or
a \link[rlang:as_function]{purrr-style formula}.

The function should take two inputs, the first being \code{x} and the second
being the left-hand side of the formula.
The function should return a logical vector, either of length 1 or the same
length as \code{x}.}
}
\value{
A list of length 1 or n, matching the length of the logical
input vector.
}
\description{
These functions are equivalent to \code{\link[=in_case]{in_case()}}, \code{\link[=switch_case]{switch_case()}},
\code{\link[=grep_case]{grep_case()}}, \code{\link[=fn_case]{fn_case()}}, and \code{\link[=fn_switch_case]{fn_switch_case()}} but return
\link[=list]{lists}.
}
\details{
This can be useful when returning a non-\link[=is.atomic]{atomic} value and/or
when you want to create a list column inside a \link[tibble:tibble]{tibble}.
}
\examples{
1:3 \%>\%
  in_case_list(
    . < 2    ~ mtcars,
    .default = letters
  )
}
\seealso{
\code{\link[=in_case]{in_case()}}, \code{\link[=switch_case]{switch_case()}}, \code{\link[=grep_case]{grep_case()}}, \code{\link[=fn_case]{fn_case()}}, and
\code{\link[=fn_case_fct]{fn_case_fct()}} on which these functions are based.
}
