% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_processing.R
\name{data_processing}
\alias{data_processing}
\title{Data processing wrapper}
\usage{
data_processing(
  reported,
  delay_dist,
  num_ar_steps = 10,
  num_ar_samps = 100,
  seed = 1,
  linear_tail = 14,
  front_pad_size = 10,
  extrapolation_prior_precision = 2
)
}
\arguments{
\item{reported}{An integer vector of reported cases.}

\item{delay_dist}{A positive vector that sums to one, which describes the delay distribution.}

\item{num_ar_steps}{An integer number of AR steps after last observation.}

\item{num_ar_samps}{An integer number of AR samples.}

\item{seed}{Seed for RNG.}

\item{linear_tail}{An integer number of days used to fit linear model on tail to be used as a mean
for AR extrapolation.}

\item{front_pad_size}{An integer for initial number of 0's before first observation.}

\item{extrapolation_prior_precision}{A positive scalar for extrapolation slope shrinkage prior precision.}
}
\value{
A list with elements: \itemize{
\item extrap =  a matrix of size (num_ar_samps x n + num_ar_steps + front_pad_size)
\item original = a vector of logicals for whether in original time series range}
}
\description{
Does basic checks for reported data and delay distribution, front pads, and makes AR extrapolation.
}
