\name{fbeta4me}
\alias{fbeta4me}

\title{
Functional Beta Biversity for MacroEcology
}
\description{
It estimates the phylogenetic beta diversity of focal cells within a SpatVector 
object by considering neighboring cells located within a specified buffer.
}
\usage{
fbeta4me(PAM, TRAITS, SHP, width = 10000, index.family="sorensen", verbose=TRUE)
}

\arguments{
  \item{PAM}{
  A presence/absence matrix where sites are organized in rows and species in 
  columns.
}
  \item{TRAITS}{
  A species x Traits matrix or a PCoA scores of functional traits. The row 
  labels must exactly match the species names in the presence/absence matrix 
  (PAM).
}
  \item{SHP}{
  A SpatVector object representing cells distributed over a geographic space
}
  \item{width}{
  Refers to the radius of the buffer. If the SpatVector object uses a 
  latitude/longitude projection, the width is specified in meters.
}
  \item{index.family}{
  Choose either the 'sorensen' or 'jaccard' dissimilarity index.
}
  \item{verbose}{
  Logical, indicating whether messages and the progress bar are shown. The 
  default is TRUE.
}
}

\value{
The function returns a data frame that includes turnover, nestedness, total 
beta diversity, and the number of cells contributing to the mean diversity of 
the focal cell. The IDs of the cells are used as the row names of the 
data frame.
}

\references{
Yang, J., Swenson, N. G., Zhang, G., Ci, X., Cao, M., Sha, L., ... & Lin, 
L. (2015). Local-scale partitioning of functional and phylogenetic beta 
diversity in a tropical tree assemblage. Scientific Reports, 5(1), 12731.
}

\author{
Guevara, R., roger.guevara@inecol.mx
}

\examples{
%Example 1
data(TRAITS)
data(PAM)
SHP <- terra::vect(paste(system.file("extdata", package = "inecolr"),
"/test.shp", sep=""))
SHP <- SHP[1:10]
f_beta <- fbeta4me(PAM, TRAITS, SHP, width = 10000, index.family="sorensen")
head(f_beta)

%Example 2
data(TRAITS)
data(PAM)
SHP <- terra::vect(paste(system.file("extdata", package = "inecolr"),
"/test.shp", sep=""))
SHP <- SHP[1:10]
f_beta <- fbeta4me(PAM, TRAITS, SHP, width = 10000, index.family="sorensen", verbose=FALSE)
head(f_beta)
}