% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v3_denue.R
\name{inegi_denue_grid}
\alias{inegi_denue_grid}
\title{Find businesses in a grid larger than 5 kms}
\usage{
inegi_denue_grid(lat1, lat2, lon1, lon2, token, meters = 5000,
  keyword = "todos", space_lat = 0.07, space_lon = 0.07,
  uniqueonly = TRUE)
}
\arguments{
\item{lat1}{First corner (latitud)}

\item{lat2}{Second corner (latitud)}

\item{lon1}{First corner (longitud)}

\item{lon2}{Second corner (longitud)}

\item{token}{API token supplied by INEGI}

\item{meters}{Distance in meters to search by coordinate}

\item{keyword}{Keyword of businesses to include. Defaults to all ("todos")}

\item{space_lat}{Space between latitud coordinates defaults to 0.07 degrees}

\item{space_lon}{Space between longitud coordinates defaults to 0.07 degrees}

\item{uniqueonly}{Default = TRUE, eliminates duplicate businesses}
}
\value{
Data.frame
}
\description{
Returns data.frame with businesses registered in the DENUE in spaces larger than 5 kilometers.
Calls \code{make_grid}. Functions contributed by Arturo Cardenas \url{https://github.com/arturocm}.
}
\details{
Makes a loop for each pair of coordinates, creating a grid to extract businesses inside. Uses maximum and minimum coordinate pairs to draw frame.
}
\examples{
\dontrun{
token<-"webservice_token"
latitud1 <- 25.669194
latitud2 <- 25.169194
longitud1 <- -100.30990
longitud2 <- -101.20102
businesses <- inegi_denue_grid(latitud1, latitud2, longitud1, longitud2, token)
}

}
\author{
Arturo Cardenas
}
