% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{influenza_vax_survey_df}
\alias{influenza_vax_survey_df}
\title{Influenza Vaccination Survey}
\format{
A data frame with 117 observations and 6 variables:
\describe{
  \item{survey}{Factor indicating which of the three ALP surveys the response came from}
  \item{freq}{Integer indicating frequency count of grouped respondents}
  \item{subject}{Integer identifier for each subject}
  \item{response}{Factor with 4 levels: "Never", "Sometimes", "Always", and "Missing"}
  \item{start_date}{Date indicating the start of the survey}
  \item{end_date}{Date indicating the end of the survey}
}
}
\source{
Data taken from the ggalluvial package version 0.12.5
}
\usage{
data(influenza_vax_survey_df)
}
\description{
This dataset, influenza_vax_survey_df, is a data frame containing aggregated responses
from three RAND American Life Panel (ALP) surveys regarding individuals' probability of
vaccinating for influenza. The responses were discretized to "Never" (0\%), "Always" (100\%),
or "Sometimes" (any other value). After merging, missing responses were coded as "Missing",
and respondents were grouped and counted by all three coded responses.
}
\details{
The dataset name has been kept as 'influenza_vax_survey_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
infectiousR package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
