% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{bru_model}
\alias{bru_model}
\alias{summary.bru_model}
\alias{print.summary_bru_model}
\alias{print.bru_model}
\title{Create an inlabru model object from model components}
\usage{
bru_model(components, lhoods, options = list(), .envir = parent.frame())

\method{summary}{bru_model}(object, ...)

\method{print}{summary_bru_model}(x, ...)

\method{print}{bru_model}(x, ...)
}
\arguments{
\item{components}{A \link{bru_comp_list} object}

\item{lhoods}{Either a \code{\link[=bru_obs]{bru_obs()}} object, a \code{\link[=bru_obs_list]{bru_obs_list()}} object, or
a list of one or more \code{\link[=bru_obs]{bru_obs()}} or \code{\link[=bru_obs_list]{bru_obs_list()}} objects,
or a list of arguments for a call to \code{\link[=bru_obs]{bru_obs()}}.}

\item{options}{A \link{bru_options} options object or a list of options passed
on to \code{\link[=bru_options]{bru_options()}}}

\item{.envir}{The environment in which the components are evaluated.}

\item{object}{Object to operate on}

\item{\dots}{Arguments passed on to other methods}

\item{x}{An object to be printed}
}
\value{
A \link{bru_model} object
}
\description{
The \link{inlabru} syntax for model formulae is different from what
\code{INLA::inla} considers a valid.
In inla most of the effects are defined by adding an \code{f(...)} expression to
the formula.
In \link{inlabru} the \code{f} is replaced by an arbitrary (exceptions: \code{const} and
\code{offset}) string that will determine the label of the effect. See Details for
further information.
}
\details{
For instance

\code{y ~ f(myspde, ...)}

in INLA is equivalent to

\code{y ~ myspde(...)}

in inlabru.

A disadvantage of the inla way is that there is no clear separation between
the name of the covariate and the label of the effect. Furthermore, for some
models like SPDE it is much more natural to use spatial coordinates as
covariates rather than an index into the SPDE vertices. For this purpose
\link{inlabru} provides the \code{main} argument. For convenience, the \code{main} argument
can be used like the first argument of the f function, e.g., and is the first
argument of the component definition.
The \code{INLA} model formula

\code{y ~ f(temperature, model = 'linear')}

is equivalent to the \code{inlabru} component and formula definition

\code{y ~ temperature(temperature, model = 'linear')}
and
\code{y ~ temperature(main = temperature, model = 'linear')}
as well as
\code{y ~ temperature(model = 'linear')}
which sets \code{main = temperature}.

On the other hand, \code{main} can also be a function mapping, e.g the
\code{sp::coordinates()} function:

\code{y ~ mySPDE(coordinates, ...)}

This extracts the coordinates from the data object, and maps it to the latent
field via the information given in the \code{mapper}, which by default is
extracted from the \code{model} object, in the case of \code{spde} model objects.

Morevover, \code{main} can be any expression that evaluates within your data as an
environment.
For instance, if your data has columns 'a' and 'b', you can create a fixed
effect of 'sin(a+b)' by setting \code{map} in the following way:

\code{y ~ myEffect(sin(a+b))}
}
\keyword{internal}
